package doABC;

import java.nio.*;
import java.util.*;
import doABC.Cpool.*;
import FlashReader.*;

public class CpoolInfo extends SwfTools {

	private AbcFile abc;
	public  int start=0;
	public  int end=0;
	
	//struktury
	private int int_count;
	private ArrayList<Integer> ints = new  ArrayList<Integer>();//s32
	private int uint_count;
	public ArrayList<Integer> uints = new ArrayList<Integer>();
	private int double_count;
	public ArrayList<Double> doubles = new ArrayList<Double>();
	private int string_count;
	private ArrayList<StringInfo> strings = new ArrayList<StringInfo>();
	private int namespace_count;
	private ArrayList<NamespaceInfo> namespaces = new ArrayList<NamespaceInfo>();
	private int ns_set_count;
	private ArrayList<NsSetInfo>  nsset= new ArrayList<NsSetInfo>();
	private int multiname_count;
	private ArrayList<MultinameInfo> multinames = new ArrayList<MultinameInfo>();
	

	public CpoolInfo(AbcFile abc){
		super();
		this.abc= abc;
	}
	
	public void cpool_info(ByteBuffer bbuf, int position){
		
		try{
		bbuf.position(position);
		start =bbuf.position();

		int_count = unsigned30int(bbuf);
		ints.add(0);
		if (int_count >0) {
			for (int i=0; i<int_count-1;i++)
				ints.add(signed32int(bbuf));
		}
	
		uint_count = unsigned30int(bbuf);
		uints.add(0);
		if (uint_count >0){
			for (int i=0; i<uint_count-1;i++)
				uints.add(unsigned32int(bbuf));	
		}
		
		double_count = unsigned30int(bbuf);
		doubles.add(0.0);
		if (double_count >0) {
			for (int i=0; i<double_count-1;i++)
				doubles.add(bbuf.getDouble());
		}
		
		string_count = unsigned30int(bbuf);
		strings.add(new StringInfo("*",0));
		if (string_count >0) {
			for (int i =0; i< string_count-1;i++)
				strings.add(new StringInfo(bbuf,strings.size()));
		}
		
		namespace_count = unsigned30int(bbuf);
		namespaces.add(new NamespaceInfo(abc.getConstant_pool(),0,0,0));
		if (namespace_count >0) {
			for (int i =0; i< namespace_count-1;i++)
				namespaces.add(new NamespaceInfo(bbuf,this));
		}
			
		ns_set_count = unsigned30int(bbuf);
		ArrayList<Integer> al = new ArrayList<Integer>();
			al.add(0);
			nsset.add(new NsSetInfo(abc.getConstant_pool(),al,0));
		if (ns_set_count >0) {
			for (int i =0; i< ns_set_count-1;i++)
				nsset.add(new NsSetInfo(bbuf,this,nsset.size()));

		}
	
		multiname_count = unsigned30int(bbuf);
		multinames.add(new MultinameInfo(abc.getConstant_pool(),0,0));
		if (multiname_count >0) {
			for (int i =0; i< multiname_count-1;i++)
				multinames.add(new MultinameInfo(bbuf,this,multinames.size()));	
		}

		end= bbuf.position()-1;
		
		}catch(Exception e){
			e.printStackTrace();
		}
		
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
		for(byte b: getUI32(int_count))
			result.add(b);

		for (int i=1;i<ints.size();i++){
			for(byte b: getSI32(ints.get(i)))
				result.add(b);
		}	
		
		for(byte b: getUI32(uint_count))
			result.add(b);
		

		for (int i=1;i<uints.size();i++){
			for(byte b: getUI32(uints.get(i)))
				result.add(b);
		}	

		for(byte b: getUI32(double_count))
			result.add(b);
		
		
		for (int i=1;i<doubles.size();i++){
			for(byte b: toBytaJava(doubles.get(i)))
				result.add(b);
		}	

		for(byte b: getUI32(string_count))
			result.add(b);

		for (int i=1;i<strings.size();i++){
			for(byte b: strings.get(i).toByteCode())
				result.add(b);	
		}
		
		for(byte b: getUI32(namespace_count))
			result.add(b);

		for (int i=1;i<namespaces.size();i++){
			for(byte b: namespaces.get(i).toByteCode())
				result.add(b);
		}
		
		for(byte b: getUI32(ns_set_count))
			result.add(b);
		
		
		for (int i=1;i<nsset.size();i++){
			for(byte b: nsset.get(i).toByteCode())
				result.add(b);
		}
		
		for(byte b: getUI32(multiname_count))
			result.add(b);


		for (int i=1;i<multinames.size();i++){
			for(byte b: multinames.get(i).toByteCode())
				result.add(b);
		}

	return result;	
	}

	//getters

	public String getString(int id) {
		return ""+strings.get(id);
	}

	public String getNamespace(int id) {
		return ""+namespaces.get(id);
	}

	public String getNsset(int id) {
		return ""+nsset.get(id);
	}

	public String getMultiname(int id) {
		return ""+multinames.get(id);
	}

	public ArrayList<StringInfo> getStrings() {
		return strings;
	}

	public ArrayList<String> getStrings_string() {
		ArrayList<String> result = new ArrayList<String> ();
		for (StringInfo str: strings)
			result.add(""+str.getUtf8_string());
		return result;
	}

	public ArrayList<NamespaceInfo> getNamespaces() {
		return namespaces;
	}

	public ArrayList<NsSetInfo> getNsset() {
		return nsset;
	}

	public ArrayList<MultinameInfo> getMultinames() {
		return multinames;
	}

	public int getInts(int id) {
		return ints.get(id);
	}

	public double getDoubles(int id) {
		return doubles.get(id);
	}
	
	public int getInt_count() {
		return int_count;
	}
	
	public ArrayList<Integer> getInts() {
		return ints;
	}
	
	public int getUint_count() {
		return uint_count;
	}
	
	public ArrayList<Integer> getUints() {
		return uints;
	}

	public int getDouble_count() {
		return double_count;
	}
	
	public ArrayList<Double> getDoubles() {
		return doubles;
	}
	
	public int getString_count() {
		return string_count;
	}
	
	public int getNamespace_count() {
		return namespace_count;
	}
	
	public int getNs_set_count() {
		return ns_set_count;
	}
	
	public int getMultiname_count() {
		return multiname_count;
	}
	
	
	//setters
	
	public void setZeroString(String s){
		strings.get(0).setString(s);
	}

	public void setInt_count(int int_count) {
		this.int_count = int_count;
	}
	
	public void setInts(ArrayList<Integer> ints) {
		this.ints = ints;
	}

	public void setUint_count(int uint_count) {
		this.uint_count = uint_count;
	}

	public void setUints(ArrayList<Integer> uints) {
		this.uints = uints;
	}

	public void setDouble_count(int double_count) {
		this.double_count = double_count;
	}
	
	public void setDoubles(ArrayList<Double> doubles) {
		this.doubles = doubles;
	}
	
	public void addInt(Integer i){
		ints.add(i);
		int_count++;
		out("ok");
	}
	
	public void removeInt(int i){
		ints.remove(i);
		int_count--;
		out("ok");
	}
	
	public void changeInt(int i, int value){
		ints.set(i,value);
		out("ok");
	}
	
	public void addUint(Integer i){
		uints.add(i);
		uint_count++;
		out("ok");
	}
	
	public void removeUint(int i){
		uints.remove(i);
		uint_count--;
		out("ok");
	}
	
	public void changeUint(int i, Integer value){
		uints.set(i,value);
		out("ok");
	}
	
	public void addDouble(Double d){
		doubles.add(d);
		double_count++;
		out("ok");
	}
	
	public void removeDouble(int i){
		doubles.remove(i);
		double_count--;
		out("ok");
	}
	
	public void changeDouble(int i, Double value){
		doubles.set(i,value);
		out("ok");
	}
	
	public void removeString(int id){
		strings.remove(id);
		string_count--;
		out("ok");
	}

	public void addString(String value){
		strings.add(new StringInfo(value,strings.size()));
		string_count++;
		out("ok");
	}
	
	public void addString(StringInfo strin){
		strings.add(strin);
		string_count++;
		out("ok");
	}
	
	public void changeString(int i, String value){
		strings.get(i).setString(value);
		out("ok");
	}
	
	public void changeString(int i, StringInfo string){
		strings.get(i).setString(string.getUtf8_string());
		out("ok");
	}
	

	public void addNamespace(NamespaceInfo ns){
		namespaces.add(ns);
		namespace_count++;
		out("ok");
	}
	
	public void removeNamespace(int i){
		namespaces.remove(i);
		namespace_count--;
		out("ok");
	}
	
	public void changeNamespace(int i, NamespaceInfo ns){
		namespaces.set(i,ns);
		out("ok");
	}
	
	public void addNsSetInfo(NsSetInfo nsSet){
		nsset.add(nsSet);
		ns_set_count++;
		out("ok");
	}
	
	public void removeNsSetInfo(int i){
		nsset.remove(i);
		ns_set_count--;
		out("ok");
	}
	
	public void changeNsSetInfo(int i, NsSetInfo nsSet){
		nsset.set(i,nsSet);
		out("ok");
	}
	
	public void addMultiname(MultinameInfo multiname){
		multinames.add(multiname);
		multiname_count++;
		out("ok");
	}
	
	public void removeMultiname(int i){
		multinames.remove(i);
		multiname_count--;
		out("ok");
	}
	
	public void changeMultiname(int i, MultinameInfo multiname){
		multinames.set(i,multiname);
		out("ok");
	}
	
	
	//toStrings
	public  String String(){
		
		StringBuffer wynik = new StringBuffer();
		try{
	
			wynik.append("int_count: "+int_count+"\n");
			wynik.append("ints: "+ints+"\n");
			wynik.append("uint_count: "+uint_count+"\n");
			wynik.append("uints: "+uints+"\n");
			wynik.append("double_count: "+double_count+"\n");
			wynik.append("doubles: "+doubles+"\n");
			
			wynik.append("string_count: "+string_count+"\n");
			wynik.append("namespace_count: "+namespace_count+"\n");
			wynik.append("ns_set_count: "+ns_set_count+"\n");
			wynik.append("multiname_count: "+multiname_count+"\n\n");
			
			wynik.append("strings: ");
			for (int i =1; i<strings.size();i++)
				wynik.append(strings.get(i).getUtf8_string() + ",");
				wynik.append("\n\n");
				wynik.append("namespaces: ");
			for (int i =1; i<namespaces.size();i++)
				wynik.append(namespaces.get(i).getName_string() + ",");
				wynik.append("\n\n");
				wynik.append("nsset: ");
			for (int i =1; i<nsset.size();i++)
				wynik.append(nsset.get(i).getNs_string() + ",");
				wynik.append("\n\n");
				wynik.append("multinames: ");
			for (int i =1; i<multinames.size();i++)
				wynik.append(multinames.get(i).getData() + ",");
				wynik.append("\n");

		}catch (Exception e){
			e.printStackTrace();
		}
		
		return wynik.toString();
}

	public String toString2(){
		String wynik ="";
		wynik+="cpool_info";
		return wynik;
	}

	public  String toString() {
		return "cpool_info " + start + " - " + end;
	}
}
